#!/bin/sh -e

if [ ! -d /Applications/CrossOver.app ]; then
  echo "Nainstaluj CrossOver do /Applications!"
  exit 1
fi

# Fix updating DB
SELF=$(dirname "$0")

# hack ze je Crossover signed
echo "Zapisuju soubor libcxsetup-v3.py.."
printf "
import os
import traceback

import appdetector
import bottlemanagement
import bottlequery
import bottlewrapper
import c4profilesmanager
import cddetector
import cxproduct
import cxaiengine
import cxmenu
import demoutils
import iconutils
import installtask
import ratingutils
import webtoken

import fileupdate

def is_really_signed(datafile, sigfile = (None,)):
    return True

fileupdate.is_signed = is_really_signed

class CXSetup(Foundation.NSObject):

    @classmethod
    def setEnvValue_forKey_(cls, value, key):
        os.environ[key] = value

    @classmethod
    def unsetEnvValueForKey_(cls, key):
        if key in os.environ:
            del os.environ[key]

    @classmethod
    def bottleCategory_(cls, category):
        return installtask.__dict__['CAT_' + category]

    @classmethod
    def dependencyReason_(cls, reason):
        return installtask.__dict__['REASON_' + reason]

    @classmethod
    def dependencyOverride_(cls, override):
        return installtask.__dict__['OVERRIDE_' + override]

    @classmethod
    def bottleStatus_(cls, status):
        return bottlewrapper.BottleWrapper.__dict__['STATUS_' + status]
" > /tmp/libcxsetup-v3.py

sudo cp "/tmp/libcxsetup-v3.py" /Applications/CrossOver.app/Contents/Resources

# Resign to avoid corruption
echo "Odstranuju podpis.."
sudo xattr -c /Applications/CrossOver.app
sudo codesign --remove-signature /Applications/CrossOver.app/Contents/MacOS/CrossOver


# Fix license
echo "Patchuju public key.."
cd ~/Library/Preferences/
openssl genrsa -out key.pem 2048
openssl rsa -in key.pem -outform PEM -pubout -out public.pem
sudo mv public.pem /Applications/CrossOver.app/Contents/SharedSupport/CrossOver/share/crossover/data/tie.pub
echo "Generuju licenci.."
sudo rm -f com.codeweavers.CrossOver.license com.codeweavers.CrossOver.sha256
printf "
[crossmac]
customer=user
email=user@apple.com
expires=2030/01/01
[license]
id=a4xdUZD2bWB00tQI
" > com.codeweavers.CrossOver.license
openssl dgst -sha256 -sign key.pem -out com.codeweavers.CrossOver.sha256 com.codeweavers.CrossOver.license
rm key.pem
echo "Konec."